# ActivityRecorder Desktop Application

## What's Included

This package contains the ActivityRecorder desktop application that works with the Chrome extension to provide a complete browser activity recording and AI analysis solution.

## IMPORTANT: Required for Chrome Extension to Work

The desktop application MUST be running to provide the localhost proxy server that enables the Chrome extension to work on all websites, including those with Content Security Policy (CSP) restrictions.

## Setup Instructions

### Step 1: Start the Proxy Server (REQUIRED)

1. Extract this zip file to your desired location
2. Install Node.js (version 16 or higher) if not already installed
3. Open a terminal/command prompt in the extracted folder
4. Run these commands:
   ```bash
   npm install
   npm run dev
   ```
5. Keep this terminal window open - the server must stay running

### Step 2: Access the Application

Once the development server is running, you can access the application at:
- `http://localhost:3000` (or the port shown in your terminal)

### Alternative: Quick Browser Access

If you just want to view the interface without the proxy functionality:
1. Navigate to the `dist` folder
2. Open `index.html` in your web browser
3. **Note**: This won't provide proxy functionality for the Chrome extension

## Desktop App Features

- **Activity Management**: View and organize your recorded browser sessions
- **AI Recipe Generation**: Create step-by-step guides from your activities
- **Recipe Library**: Browse and manage your generated recipes
- **Native Integration**: Works seamlessly with your operating system
- **Offline Capability**: Core features work without internet connection

## How It Works

1. **Start Desktop App**: Run `npm run dev` to start the proxy server (REQUIRED)
2. **Install Chrome Extension**: Download and install the browser extension from the landing page
3. **Record Activities**: Use the extension to capture your browser interactions
4. **View in Desktop App**: Access http://localhost:3000 to view and process recordings
5. **Generate Recipes**: Describe your task and let AI create step-by-step guides
6. **Universal Compatibility**: The proxy server enables recording on ALL websites

## Critical: Why the Proxy Server is Required

Many websites use Content Security Policy (CSP) headers that block browser extensions from working properly. The desktop application runs a localhost proxy server that:
- Bypasses CSP restrictions
- Enables universal website compatibility
- Allows the extension to capture activities on ANY website
- Provides secure communication between extension and backend

## Requirements

- Node.js 16+ 
- Chrome browser with ActivityRecorder extension installed
- Internet connection for AI features

## Support

For help and documentation, visit the ActivityRecorder landing page or contact support.