# ActivityRecorder Desktop Client

## Quick Start

### Dependencies Installation
```bash
npm install
```

### Development Mode
```bash
npm run dev
```
This starts both:
- Vite React UI on port 3000
- Proxy server on port 8080 (for Chrome extension communication)

### Production Mode
```bash
npm run build
npm run electron
```

## Architecture

This desktop application runs two processes:

1. **Electron GUI Process** (port 3000)
   - Serves the React UI for managing recordings and viewing recipes
   - Main user interface for the application

2. **Background Proxy Process** (port 8080)  
   - Handles Chrome extension communication
   - Bypasses Content Security Policy (CSP) restrictions
   - Required for universal website compatibility

## Required Setup

1. Install all dependencies: `npm install`
2. Start development mode: `npm run dev`
3. Install and configure the Chrome extension
4. Both processes must be running for full functionality

## Troubleshooting

**If you see "Could not resolve vite.config.debug.js":**
- Use the main vite.config.ts (now fixed in latest package)
- Run `npm run dev:simple` as alternative

**If you see "vite started on port 5173":**
- Dependencies are missing, run `npm install`
- Check that `concurrently` is installed

**If proxy server doesn't start:**
- Check that port 8080 is available
- Ensure Node.js supports ES modules

**If activity streaming fails with "Unexpected end of JSON input":**
- Backend server may not be reachable from your network
- Set BACKEND_URL environment variable to the correct server URL
- Check firewall/network settings if using custom backend

**If SSL certificate errors occur:**
- SSL verification is automatically bypassed for HTTPS backends in development
- Look for "SSL: Certificate validation disabled" in proxy logs
- This is normal and safe for development/testing environments

**Success indicators:**
- ✅ Proxy server: "Running on http://localhost:8080"
- ✅ Vite client: "Local: http://localhost:3000" 
- ✅ Both processes running with concurrently
- ✅ Activity streaming: No JSON parsing errors in proxy logs

## Backend Connection

The proxy server automatically detects the correct backend URL:
- Uses REPLIT_DEV_DOMAIN environment variable when available
- Falls back to localhost:5000 for local development  
- Can be overridden with BACKEND_URL environment variable

```bash
# Override backend URL if needed
BACKEND_URL=https://your-backend-url.com npm run dev
```