import { Switch, Route } from "wouter";
import { queryClient } from "./lib/queryClient";
import { QueryClientProvider } from "@tanstack/react-query";
import { Toaster } from "@/components/ui/toaster";
import { TooltipProvider } from "@/components/ui/tooltip";
import Home from "@/pages/home";
import IncrementalTest from "@/pages/incremental-test";
import Feedback from "@/pages/feedback";
import Recordings from "@/pages/recordings";
import RecipesPage from "@/pages/RecipesPage";
import DebugCapture from "@/pages/debug-capture";
import NotFound from "@/pages/not-found";

function Router() {
  return (
    <Switch>
      <Route path="/" component={Home} />
      <Route path="/recipes" component={RecipesPage} />
      <Route path="/test" component={IncrementalTest} />
      <Route path="/debug" component={DebugCapture} />
      <Route path="/recordings" component={Recordings} />
      <Route path="/feedback/:id" component={Feedback} />
      <Route component={NotFound} />
    </Switch>
  );
}

function App() {
  return (
    <QueryClientProvider client={queryClient}>
      <TooltipProvider>
        <Toaster />
        <Router />
      </TooltipProvider>
    </QueryClientProvider>
  );
}

export default App;
