// Script to generate extension icons
// This would typically use a proper image generation library
// For now, creating SVG placeholders that can be converted to PNG

const fs = require('fs');

const svgTemplate = (size) => `
<svg width="${size}" height="${size}" xmlns="http://www.w3.org/2000/svg">
  <defs>
    <linearGradient id="grad" x1="0%" y1="0%" x2="100%" y2="100%">
      <stop offset="0%" style="stop-color:#667eea;stop-opacity:1" />
      <stop offset="100%" style="stop-color:#764ba2;stop-opacity:1" />
    </linearGradient>
  </defs>
  <rect width="${size}" height="${size}" rx="${size/8}" fill="url(#grad)"/>
  <path d="M${size*0.3} ${size*0.25} L${size*0.7} ${size*0.5} L${size*0.3} ${size*0.75} Z" fill="white"/>
</svg>
`;

// Generate SVG files for different sizes
[16, 32, 48, 128].forEach(size => {
  fs.writeFileSync(`icon${size}.svg`, svgTemplate(size));
});

console.log('SVG icons generated. Convert to PNG using your preferred tool.');