# ActivityRecorder Chrome Extension

## Installation

1. Download this extension folder
2. Open Chrome and go to `chrome://extensions/`
3. Enable "Developer mode" in the top right
4. Click "Load unpacked" and select this folder
5. Pin the extension to your toolbar

## Usage

1. Click the extension icon to open the popup
2. Click "Start Recording" to begin capturing your browser activities
3. Perform your workflow across any tabs
4. Click "Stop Recording" when finished
5. Describe what you accomplished
6. Click "Generate Guide" to create an AI-powered step-by-step recipe

## Features

- **Multi-tab Recording**: Captures activities across all browser tabs
- **Smart Filtering**: Only records user-initiated actions
- **Visual Context**: Automatic screenshot capture for better AI analysis
- **Real-time Streaming**: Activities are processed as they happen
- **Privacy Focused**: Sensitive data is automatically filtered out

## Configuration

Update the API endpoint in `background.js`:

```javascript
const API_BASE_URL = 'https://your-api-domain.com';
```

## Support

For help and documentation, visit the portal or landing page.